package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

/** Klasa obsugi znacznika else. Odczytuje ona
 *  instancj klasy IfTag i przetwarza swoj tre,
 *  jeeli atrybut test klasy IfTag ma warto false. Ponadto
 *  rzucany jest wyjtek JspTagException, jeeli przodkiem
 *  znacznika nie jest instancja klasy IfTag.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ElseTag extends SimpleTagSupport {
  public void doTag() throws JspException, IOException {
    // Odczytanie znacznika przodka (znacznika if)
	IfTag ifTag = null;
	try {
	  ifTag = (IfTag)getParent();
	}
	catch (ClassCastException cce) {
	  String msg =
	    "Bd: 'else' musi si znajdowa w 'if'.";
	  throw new JspTagException(msg);
	}

    if (ifTag != null) {
      // Decyzja, czy naley zwrci tre znacznika else
      if (!ifTag.getTest()) {
        getJspBody().invoke(null);
      }
    } else {
      String msg =
        "Bd: 'else' musi si znajdowa w 'if'.";
      throw new JspTagException(msg);
    }
  }
}
